<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cadeau extends Model 
{

    protected $table = 'cadeaux';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('invite_id', 'slug', 'key_pay_api', 'montant', 'received_amount', 'nom', 'devise', 'methode', 'statut');
    protected $visible = array('invite_id', 'slug', 'key_pay_api', 'montant', 'received_amount', 'nom', 'devise', 'methode', 'statut');

    public function invite()
    {
        return $this->belongsTo('App\Models\Invite', 'invite_id');
    }

}